package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;

import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;

import org.apache.poi.ss.usermodel.Sheet;
import org.w3c.dom.Element;

public class VerticalRepeatsSeeker extends AbstractRepeatsSeeker {

	@Override
	public void set(Element element, ExcelPOJOXmlParser parser) {
		parser.setCellSeeker(element, this);
	}

	@Override
	public void set(Annotation annotation, ExcelPOJOAnnotationParser parser) throws ClassNotFoundException, LinkageError {
		parser.setCellSeeker(annotation, this);
	}

	@Override
	int getRowLimit(Sheet sheet) {
		return sheet.getLastRowNum();
	}

	@Override
	Offset getOffset(int rowIndex) {
		return new Offset(rowIndex, 0);
	}

	@Override
	Offset getOffset4MappedCell(int rowIndex) {
		return new Offset(rowIndex -1, 1);
	}

	@Override
	protected Offset getRangeOffset() {
		return new Offset(0, -1);
	}

}
